/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.recipes.catalyst;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.compactmods.crafting.api.catalyst.CatalystType;
import dev.compactmods.crafting.api.catalyst.ICatalystMatcher;
import dev.compactmods.crafting.core.CCCatalystTypes;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ItemStackCatalystMatcher
extends ForgeRegistryEntry<CatalystType<?>>
implements ICatalystMatcher,
CatalystType<ItemStackCatalystMatcher> {
    public static final Codec<ItemStackCatalystMatcher> CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.f_135803_.fieldOf("item").forGetter(ItemStackCatalystMatcher::getItemId), (App)CompoundTag.f_128325_.optionalFieldOf("nbt").forGetter(ItemStackCatalystMatcher::getNbtTag)).apply((Applicative)i, ItemStackCatalystMatcher::new));
    private final Predicate<ItemStack> nbtMatcher;
    private final Item item;

    private Optional<CompoundTag> getNbtTag() {
        return Optional.of(new CompoundTag());
    }

    public ItemStackCatalystMatcher() {
        this.item = null;
        this.nbtMatcher = stack -> true;
    }

    public ItemStackCatalystMatcher(ResourceLocation item, Optional<CompoundTag> nbt) {
        this.item = (Item)ForgeRegistries.ITEMS.getValue(item);
        this.nbtMatcher = this.buildMatcher(nbt.orElse(null));
    }

    public ItemStackCatalystMatcher(ItemStack stack) {
        this.item = stack.m_41720_();
        this.nbtMatcher = s -> true;
    }

    private Predicate<ItemStack> buildMatcher(CompoundTag filter) {
        if (filter == null) {
            return stack -> true;
        }
        return stack -> {
            if (!stack.m_41782_() && !filter.m_128456_()) {
                return false;
            }
            return this.tagMatched(stack.m_41783_(), filter);
        };
    }

    private boolean tagMatched(CompoundTag node, CompoundTag filter) {
        if (filter.m_128456_()) {
            return true;
        }
        return filter.m_128431_().stream().allMatch(key -> {
            if (!node.m_128441_(key)) {
                return false;
            }
            byte tagType = filter.m_128435_(key);
            if (tagType == 10) {
                return this.tagMatched(node.m_128469_(key), filter.m_128469_(key));
            }
            Tag primitive = node.m_128423_(key);
            if (primitive == null) {
                return false;
            }
            return primitive.equals(filter.m_128423_(key));
        });
    }

    public ResourceLocation getItemId() {
        return this.item.getRegistryName();
    }

    @Override
    public boolean matches(ItemStack stack) {
        return stack.m_41720_().equals(this.item) && this.nbtMatcher.test(stack);
    }

    @Override
    public CatalystType<?> getType() {
        return (CatalystType)CCCatalystTypes.ITEM_STACK_CATALYST.get();
    }

    @Override
    public Set<ItemStack> getPossible() {
        HashSet<ItemStack> set = new HashSet<ItemStack>();
        set.add(new ItemStack((ItemLike)this.item));
        return set;
    }

    @Override
    public Codec<ItemStackCatalystMatcher> getCodec() {
        return CODEC;
    }
}

